#include "GLOBAL.H"
#include "UART.H"


//----- DECRYPT.C -----//
extern void Decrypt_Data(void);

//----- IAP.C -----//
extern void IAP_Erase( BYTE , BYTE );
extern void IAP_Program( BYTE , BYTE , BYTE );
extern BYTE IAP_Read(BYTE , BYTE );

//----- MCU.C -----//
extern void Reboot_Mcu( BYTE );

//----- TIMER0.C -----//
extern BYTE T0Cnt;                               // Timer0 Count

idata BYTE UART_Buf[Buffer_Size];

UART Uart;

void INT_UART(void) interrupt	4	using	2
{ 	
  if( RI )
  { RI = CLR;
    UART_Buf[Uart.Index] = SBUF;
    Uart.Index ++;
  }
  else
  { TI = CLR;
    Uart.TxBusy = CLR;                           // UART Tx down
  }
}


void UART_Send_Data( BYTE Dta )
{ SBUF = Dta;
	
  Uart.TxBusy = SET;
  while( Uart.TxBusy );                          // Wait UART Tx down
}


void UART_Send_Status( BYTE Sta )
{ UART_Send_Data( Tag_1 );
  UART_Send_Data( Tag_0 );
  UART_Send_Data( Sta );
}


void UART_Event( void )
{ BYTE Page_Cnt;
  BYTE i;
  BYTE Tmp;

  
  if(Uart.Stage == UART_Idle)
  { if( Uart.Index == 15 )                       // Command Length
    { Uart.Index = 0;
      if((UART_Buf[0] == Tag_0) && (UART_Buf[1] == Tag_1) && (UART_Buf[2] == 0x80))
      { T0Cnt = 0;                               // clear Over Time
        Uart.Addr.B[0] = UART_Buf[3];            // MSB, Addr
        Uart.Addr.B[1] = UART_Buf[4];            // ..
        Uart.Addr.B[2] = UART_Buf[5];            // ..
        Uart.Addr.B[3] = UART_Buf[6];            // LSB, Addr
        
        Uart.Size.B[0] = UART_Buf[7];            // MSB, Size
        Uart.Size.B[1] = UART_Buf[8];            // ..
        Uart.Size.B[2] = UART_Buf[9];            // ..
        Uart.Size.B[3] = UART_Buf[10];           // LSB, Size
       
        Uart.ChkSum.B[0] = UART_Buf[11];         // MSB
        Uart.ChkSum.B[1] = UART_Buf[12];         // LSB
        	
        Page_Cnt = Uart.Size.B[2] >> 1;
        if ( Uart.Size.W[1] & 0x1FF )
          Page_Cnt++;
        IAP_Erase( Uart.Addr.B[2] , Page_Cnt );
        
        Uart.Stage = UART_CmdIn;                 // UART stage change to CMD/DATA in stage
        Uart.ChkSum_tmp.W = 0;
        if ( Uart.Size.W[1] > Buffer_Size )
          Uart.RW_Size = Buffer_Size;
        else
          Uart.RW_Size = Uart.Size.B[3];
		
        UART_Send_Status( ACK );                 // Return ACK to Host
      }
    }
    else if( Uart.Index == 3 )
    { if((UART_Buf[0] == Tag_0) && (UART_Buf[1] == Tag_1) && (UART_Buf[2] == 0x88))
      { Reboot_Mcu( REBOOT_TO_AP );
      }
    }
  }
  else if( Uart.Stage == UART_CmdIn )
  { if( Uart.Index == Uart.RW_Size )
    { Decrypt_Data();                            // decrypt data ( User Define )
	
      T0Cnt = 0;                                 // clear Over Time
      Uart.Index = 0;
      i = 0;
      while( i < Uart.RW_Size )
      { IAP_Program( Uart.Addr.B[2], Uart.Addr.B[3], UART_Buf[i] );
        Tmp = IAP_Read( Uart.Addr.B[2], Uart.Addr.B[3] );
        if ( Tmp != UART_Buf[i] )                // verify data
        { Uart.Stage = UART_Idle;
          UART_Send_Status( NACK );              // Return NACK to Host
          return;
        }
        Uart.ChkSum_tmp.W += Tmp;                // do checksum
        Uart.Addr.W[1]++;
        i++;
      }
      
      Uart.Size.W[1] -= Uart.RW_Size;
      if ( Uart.Size.W[1] == 0x0000 )
      { Uart.Stage = UART_Idle;
      	if ( Uart.ChkSum_tmp.W != Uart.ChkSum.W )
          UART_Send_Status( NACK );              // Return NACK to Host
        else
          UART_Send_Status( ACK );               // Return ACK to Host
      }
      else
      { if ( Uart.Size.W[1] > Buffer_Size )
          Uart.RW_Size = Buffer_Size;
        else
          Uart.RW_Size = Uart.Size.B[3];
      	UART_Send_Status( ACK );                 // Return ACK to Host
      }
    }
  }
}


void Initial_UART( void )
{ Uart.Stage = UART_Idle;
  Uart.Index = CLR;

  TMOD |= 0x20;                                  // Set Timer1 at Mode 1
  SCON = 0x50;                                   // Set UART0 at 8bit Mode
  TH1 = 0xFF;                                    // BR = 57600@11.059Mhz
  TL1 = 0xFF;                                    // 
  PCON |= 0x80;                                  // 
}